-- new script file

function OnAfterSceneLoaded(self)
  self:AddTriggerTarget("victory")  
  self:AddTriggerTarget("defeat")
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.p0 = Citadels.GetPlayer(0)
    self.victory = false
    self.defeat = false
    
    if not self.loaded then
      self.timer = 4
      MarkMainGoal(self)
    end
  end
  
  if self.victory then
    self.p0:WinQuest('D08G_GOAL_2')
    td = Timer:GetTimeDiff()
    self.timer = self.timer - td
  	
    if self.timer <= 0 then
      Citadels.SetAchievementDone(13)
      Citadels.ForceVictory()
    end
  end
  
  if self.defeat then
    self.p0:FailQuest('D08G_GOAL_1')
    self.p0:FailQuest('D08G_GOAL_2')
    
    td = Timer:GetTimeDiff()
    self.timer = self.timer - td
    
    if self.timer <= 0 then
      Citadels.ForceDefeat()
    end
  end  
end

function MarkMainGoal(self)
  gPosX = Game:GetEntity("mainBase"):GetPosition().x
  gPosY = Game:GetEntity("mainBase"):GetPosition().y

  self.p0:AddQuest('D8G_GOAL_1','main')   
  self.p0:SetQuestPosition('D8G_GOAL_1', gPosX, gPosY)
end

function OnTrigger(self, source, target)
  if target == "victory" then
    self.victory = true
  elseif target == "defeat" then
    self.defeat = true
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    self.loaded = true
    self.timer = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.timer)
  end
end
